function Z_out = Data_filtering(Z,k_elements)
if nargin == 1
    k_elements = 3;
end

z_outlier = isoutlier(Z);
[row_vec,col_vec] = find(z_outlier);
fprintf('%d outliers found \n',length(z_outlier))

for i = 1:sum(sum(z_outlier))
    row = row_vec(i);
    col = col_vec(i);
    % local_mean = mean(Z([row-1 row+1],[col-1 col+1]),'all');
    local_mean_col = movmean(Z,k_elements,2);
    local_mean_row = movmean(Z,k_elements,1);
    local_mean = mean([local_mean_row(row,col) local_mean_col(row,col)]);
    Z(row,col) = local_mean;
end

% 
% nPoints = size(Z,1);
% nMeasurements = size(Z,2);
% 
% for i = 2:nPoints-1
% for j = 2:nMeasurements-1
%     local_mean = mean(Z([i-1 i+1],[j-1 j+1]),'all');
%     if abs(Z(i,j)-local_mean)/local_mean > delta
%         Z(i,j) = local_mean;
%     end
% end
% end
Z_out = Z;
end